/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskASMLibChecks;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskASMLibChecks {
    private final String m_asmLibInitDPath = "/etc/init.d/oracleasm";
    private String m_asmLibCommandPath = null;
    private final String m_asmLibMountPath = "/dev/oracleasm";
    private final String m_asmListDisksCommand = " listdisks";
    private final String m_asmQueryDiskCommand = " querydisk ";
    private final String m_asmLibConfigFilePath_link = "/etc/sysconfig/oracleasm";
    private final String m_asmLibConfigFilePath = "/etc/sysconfig/oracleasm-_dev_oracleasm";
    private final String[] m_asmLibConfigParameters = new String[]{"ORACLEASM_ENABLED", "ORACLEASM_UID", "ORACLEASM_GID", "ORACLEASM_SCANBOOT", "ORACLEASM_SCANORDER", "ORACLEASM_SCANEXCLUDE"};
    private TaskASMLibChecks m_taskASMLib;
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public sTaskASMLibChecks(TaskASMLibChecks taskASMLib) {
        this.m_taskASMLib = taskASMLib;
    }

    public void performVerification(Vector<String> asmLibNotInstallNodes, Vector<String> asmLibNotConfiguredNodes, Vector<String> asmLibCommandPathInconsistentNodes, Vector<String> asmLibDiskNotConsistentNodes, Vector<String> operationFailedNode, Hashtable<String, Vector<String>> nodeAbsentDisksPair) {
        GlobalExecution globalExec = new GlobalExecution();
        boolean result = false;
        ResultSet asmLibChkRsltSet = new ResultSet();
        this.m_taskASMLib.isASMLibInstallConsistent = VerificationUtil.isASMLibInstallConsistent(this.m_taskASMLib.m_nodeList, asmLibChkRsltSet, asmLibNotInstallNodes, operationFailedNode);
        if (this.m_taskASMLib.isASMLibInstallConsistent && asmLibNotInstallNodes.size() == 0) {
            asmLibChkRsltSet.clear();
            this.m_taskASMLib.isASMLibConfigConsistent = VerificationUtil.isASMLibConfiguredConsistently(this.m_taskASMLib.m_nodeList, asmLibChkRsltSet, asmLibNotConfiguredNodes, operationFailedNode);
            if (this.m_taskASMLib.isASMLibConfigConsistent && asmLibNotConfiguredNodes.size() == 0) {
                asmLibChkRsltSet.clear();
                String configInfoFilePath = "/etc/sysconfig/oracleasm";
                result = globalExec.checkFileExistence(this.m_taskASMLib.m_nodeList, configInfoFilePath, asmLibChkRsltSet);
                if (asmLibChkRsltSet.anyFailure()) {
                    asmLibChkRsltSet.clear();
                    configInfoFilePath = "/etc/sysconfig/oracleasm-_dev_oracleasm";
                    result = globalExec.checkFileExistence(this.m_taskASMLib.m_nodeList, configInfoFilePath, asmLibChkRsltSet);
                }
                if (asmLibChkRsltSet.allSuccess()) {
                    asmLibChkRsltSet.clear();
                    result = this.checkASMLibConfigParamConsistency(this.m_taskASMLib.m_nodeList, configInfoFilePath, asmLibNotConfiguredNodes, operationFailedNode, asmLibChkRsltSet);
                    if (result && asmLibChkRsltSet.allSuccess()) {
                        asmLibChkRsltSet.clear();
                        String asmLibCommandPath = this.getASMLibCommandPath(this.m_taskASMLib.m_nodeList, asmLibCommandPathInconsistentNodes, asmLibChkRsltSet);
                        if (asmLibCommandPathInconsistentNodes.size() > 0) {
                            this.m_taskASMLib.isASMLibCommandPathConsistent = false;
                            this.m_taskASMLib.m_resultSet.uploadResultSet(asmLibChkRsltSet);
                        }
                        String[] commandAvailableNodes = asmLibChkRsltSet.getSuccNodes();
                        if (VerificationUtil.isStringGood(asmLibCommandPath) && commandAvailableNodes != null && commandAvailableNodes.length > 0) {
                            asmLibChkRsltSet.clear();
                            this.m_taskASMLib.isASMLibDisksConsistent = this.isASMDiskListConsistent(commandAvailableNodes, asmLibCommandPath, asmLibChkRsltSet, asmLibDiskNotConsistentNodes, operationFailedNode, nodeAbsentDisksPair);
                            this.m_taskASMLib.m_resultSet.uploadResultSet(asmLibChkRsltSet);
                        }
                    } else {
                        this.m_taskASMLib.isASMLibConfigConsistent = false;
                        this.m_taskASMLib.m_resultSet.uploadResultSet(asmLibChkRsltSet);
                    }
                } else {
                    this.m_taskASMLib.isASMLibConfigConsistent = false;
                    this.m_taskASMLib.m_resultSet.uploadResultSet(asmLibChkRsltSet);
                }
            } else {
                this.m_taskASMLib.m_resultSet.uploadResultSet(asmLibChkRsltSet);
            }
        } else {
            this.m_taskASMLib.m_resultSet.uploadResultSet(asmLibChkRsltSet);
        }
    }

    private String getASMLibCommandPath(String[] nodeList, Vector<String> asmLibCommandPathInconsistentNodes, ResultSet asmLibCommandRsltSet) {
        Trace.out((String)"ENTRY");
        if (!VerificationUtil.isStringGood(this.m_asmLibCommandPath)) {
            GlobalExecution globalExec = new GlobalExecution();
            boolean result = false;
            if (null == asmLibCommandRsltSet) {
                asmLibCommandRsltSet = new ResultSet();
            }
            StringBuilder stringBuilder = new StringBuilder().append("Determining the existence of an oracleasm command utility at path (");
            this.m_taskASMLib.getClass();
            Trace.out((String)stringBuilder.append("/usr/sbin/oracleasm").append(") on nodes ").append(VerificationUtil.strArr2List(nodeList)).toString());
            StringBuilder stringBuilder2 = new StringBuilder().append("Determining the existence of an oracleasm command utility at path (");
            this.m_taskASMLib.getClass();
            VerificationLogData.logInfo(stringBuilder2.append("/usr/sbin/oracleasm").append(") on nodes ").append(VerificationUtil.strArr2List(nodeList)).toString());
            this.m_taskASMLib.getClass();
            result = globalExec.checkFileExistence(nodeList, "/usr/sbin/oracleasm", asmLibCommandRsltSet);
            if (result && asmLibCommandRsltSet.allSuccess()) {
                StringBuilder stringBuilder3 = new StringBuilder().append("Found oracleasm command utility at path (");
                this.m_taskASMLib.getClass();
                Trace.out((String)stringBuilder3.append("/usr/sbin/oracleasm").append(") on all the nodes ").append(asmLibCommandRsltSet.getSuccessfulNodes()).toString());
                StringBuilder stringBuilder4 = new StringBuilder().append("Found oracleasm command utility at path (");
                this.m_taskASMLib.getClass();
                VerificationLogData.logInfo(stringBuilder4.append("/usr/sbin/oracleasm").append(") on all the nodes ").append(asmLibCommandRsltSet.getSuccessfulNodes()).toString());
                this.m_taskASMLib.getClass();
                this.m_asmLibCommandPath = "/usr/sbin/oracleasm";
            } else if (asmLibCommandRsltSet.anySuccess()) {
                StringBuilder stringBuilder5 = new StringBuilder().append("Found oracleasm command utility at path (");
                this.m_taskASMLib.getClass();
                Trace.out((String)stringBuilder5.append("/usr/sbin/oracleasm").append(") on some nodes ").append(asmLibCommandRsltSet.getSuccessfulNodes()).toString());
                StringBuilder stringBuilder6 = new StringBuilder().append("Found oracleasm command utility at path (");
                this.m_taskASMLib.getClass();
                VerificationLogData.logInfo(stringBuilder6.append("/usr/sbin/oracleasm").append(") on some nodes ").append(asmLibCommandRsltSet.getSuccessfulNodes()).toString());
                String[] asmLibCommandAbsentNodes = asmLibCommandRsltSet.getFailureNodes();
                if (null != asmLibCommandAbsentNodes && asmLibCommandAbsentNodes.length > 0) {
                    for (String failedNode : asmLibCommandAbsentNodes) {
                        StringBuilder stringBuilder7 = new StringBuilder().append("Not Found oracleasm command utility at path (");
                        this.m_taskASMLib.getClass();
                        Trace.out((String)stringBuilder7.append("/usr/sbin/oracleasm").append(") on node ").append(failedNode).toString());
                        StringBuilder stringBuilder8 = new StringBuilder().append("Not Found oracleasm command utility at path (");
                        this.m_taskASMLib.getClass();
                        VerificationLogData.logInfo(stringBuilder8.append("/usr/sbin/oracleasm").append(") on node ").append(failedNode).toString());
                        Object[] objectArray = new String[2];
                        this.m_taskASMLib.getClass();
                        objectArray[0] = "/usr/sbin/oracleasm";
                        objectArray[1] = failedNode;
                        String errMsg = s_gMsgBundle.getMessage("10123", true, objectArray);
                        asmLibCommandPathInconsistentNodes.add(failedNode);
                        asmLibCommandRsltSet.addErrorDescription(failedNode, new ErrorDescription(errMsg));
                    }
                }
                this.m_taskASMLib.getClass();
                this.m_asmLibCommandPath = "/usr/sbin/oracleasm";
            } else {
                StringBuilder stringBuilder9 = new StringBuilder().append("Not Found oracleasm command utility at path (");
                this.m_taskASMLib.getClass();
                Trace.out((String)stringBuilder9.append("/usr/sbin/oracleasm").append(") on any of the node, hence returning the (").append("/etc/init.d/oracleasm").append(") as a fallback").toString());
                StringBuilder stringBuilder10 = new StringBuilder().append("Not Found oracleasm command utility at path (");
                this.m_taskASMLib.getClass();
                VerificationLogData.logInfo(stringBuilder10.append("/usr/sbin/oracleasm").append(") on any of the node, hence returning the (").append("/etc/init.d/oracleasm").append(") as a fallback").toString());
                this.m_asmLibCommandPath = "/etc/init.d/oracleasm";
                asmLibCommandRsltSet.clear();
                asmLibCommandRsltSet.addResult(nodeList, 1);
            }
        } else {
            asmLibCommandRsltSet.addResult(nodeList, 1);
        }
        Trace.out((String)"EXIT");
        return this.m_asmLibCommandPath;
    }

    private boolean isASMDiskListConsistent(String[] nodeList, String asmLibCommandPath, ResultSet asmListDisksRsltSet, Vector<String> asmLibDiskNotConsistentNodes, Vector<String> operationFailedNode, Hashtable<String, Vector<String>> nodeAbsentDisksPair) {
        Hashtable nodeOutputPair;
        Hashtable<String, List<String>> diskNodesPair;
        Trace.out((String)"ENTRY");
        boolean diskListConsistent = true;
        GlobalExecution globalExec = new GlobalExecution();
        String command = asmLibCommandPath + " listdisks";
        if (null == asmListDisksRsltSet) {
            asmListDisksRsltSet = new ResultSet();
        }
        if ((diskNodesPair = this.verifyDisksOnNodes(nodeList, nodeOutputPair = globalExec.runExeWithOutput(nodeList, command, asmListDisksRsltSet, true), asmListDisksRsltSet)) != null && diskNodesPair.size() > 0) {
            Set<String> diskSet = diskNodesPair.keySet();
            Object[] disksList = diskSet.toArray();
            for (int i = 0; i < disksList.length; ++i) {
                String diskName = disksList[i].toString();
                List<String> tempnodes = diskNodesPair.get(diskName);
                if (tempnodes == null || tempnodes.size() == 0) continue;
                diskListConsistent = false;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("The Disk : " + diskName + " found missing on following nodes:"));
                }
                VerificationLogData.log("The Disk : " + diskName + " found missing on following nodes:");
                for (int j = 0; j < tempnodes.size(); ++j) {
                    String nodeName = tempnodes.get(j);
                    if (nodeAbsentDisksPair.size() > 0 && nodeAbsentDisksPair.containsKey(nodeName)) {
                        if (!nodeAbsentDisksPair.get(nodeName).contains(diskName)) {
                            nodeAbsentDisksPair.get(nodeName).add(diskName);
                        }
                    } else {
                        Vector<String> absentDisksOnNode = new Vector<String>();
                        absentDisksOnNode.add(diskName);
                        nodeAbsentDisksPair.put(nodeName, absentDisksOnNode);
                    }
                    asmListDisksRsltSet.getResult(nodeName).setStatus(3);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Node : " + nodeName));
                    }
                    VerificationLogData.log("Node : " + nodeName);
                    if (asmLibDiskNotConsistentNodes.contains(nodeName)) continue;
                    asmLibDiskNotConsistentNodes.add(nodeName);
                }
            }
        }
        Hashtable ht = asmListDisksRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result resultNode = (Result)ht.get(node);
            if (resultNode.getStatus() == 3 && asmLibDiskNotConsistentNodes.contains(node)) {
                String missingDisks = nodeAbsentDisksPair.get(node).toString();
                String errMsg = s_msgBundle.getMessage("10112", true, (Object[])new String[]{missingDisks, node});
                asmListDisksRsltSet.addErrorDescription(node, new ErrorDescription(errMsg));
                diskListConsistent = false;
                continue;
            }
            if (resultNode.getStatus() != 2) continue;
            String errMsg = s_msgBundle.getMessage("10108", true, (Object[])new String[]{node});
            asmListDisksRsltSet.addErrorDescription(node, new ErrorDescription(errMsg));
            operationFailedNode.add(node);
            diskListConsistent = false;
        }
        Trace.out((String)"EXIT");
        return diskListConsistent;
    }

    public boolean isASMLIBPath(String path) {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet asmLibInstallRsltSet = new ResultSet();
        globalExec.checkFileExistence(this.m_taskASMLib.m_nodeList, "/etc/init.d/oracleasm", asmLibInstallRsltSet);
        if (asmLibInstallRsltSet.anySuccess()) {
            String[] asmLibInstNodes = asmLibInstallRsltSet.getSuccNodes();
            this.m_taskASMLib.isASMLibInstallConsistent = true;
            ResultSet asmLibconfiguredRsltSet = new ResultSet();
            globalExec.checkFileExistence(asmLibInstNodes, "/dev/oracleasm", asmLibconfiguredRsltSet);
            if (asmLibconfiguredRsltSet.anySuccess()) {
                Vector<String> asmLibCommandPathInconsistentNodes = new Vector<String>();
                ResultSet asmQueryDiskRsltSet = new ResultSet();
                String command = this.getASMLibCommandPath(asmLibconfiguredRsltSet.getSuccNodes(), asmLibCommandPathInconsistentNodes, asmQueryDiskRsltSet) + " querydisk " + path;
                if (asmQueryDiskRsltSet.anySuccess()) {
                    String[] asmLibConfigNodes = asmQueryDiskRsltSet.getSuccNodes();
                    asmQueryDiskRsltSet.clear();
                    Hashtable nodeOutputPair = globalExec.runExeWithOutput(asmLibConfigNodes, command, asmQueryDiskRsltSet);
                    for (String node : asmLibConfigNodes) {
                        Result nodeResult = asmQueryDiskRsltSet.getResult(node);
                        if (nodeResult.getStatus() != 1) {
                            Trace.out((String)("oracleasm command failed on node: " + node));
                            VerificationLogData.logError("oracleasm command failed on node: " + node);
                            continue;
                        }
                        Trace.out((String)("Checking if the path '" + path + "' is being managed by ASMLIB on node '" + node + "'"));
                        String etOutput = (String)nodeOutputPair.get(node);
                        Trace.out((String)("oracleasm querydisk output is: '" + etOutput + "'"));
                        if (!etOutput.toLowerCase().contains("valid asm disk")) continue;
                        return true;
                    }
                } else {
                    Trace.out((String)"Failed to run query for the disk path");
                }
            } else {
                Trace.out((String)"ASMLib not found configured on any of the nodes");
            }
        } else {
            Trace.out((String)"ASMLib not found installed on any of the nodes");
        }
        return false;
    }

    private Hashtable<String, List<String>> verifyDisksOnNodes(String[] nodeList, Hashtable<String, String> nodeOutputPair, ResultSet nodeListResults) {
        Vector<String> failedNodes = new Vector<String>();
        for (String node : nodeList) {
            if (nodeOutputPair.containsKey(node)) {
                String eOutput = nodeOutputPair.get(node);
                if (VerificationUtil.fetchExecResult(eOutput) && VerificationUtil.fetchVerificationStatus(eOutput)) continue;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Verification/Operation failed on the node: " + node + " updating the result set as operation failed"));
                }
                VerificationLogData.logError("Verification/Operation failed on the node: " + node + " updating the result set as operation failed");
                nodeListResults.getResult(node).setStatus(2);
                failedNodes.add(node);
                continue;
            }
            nodeListResults.getResult(node).setStatus(2);
            failedNodes.add(node);
        }
        Hashtable<String, List<String>> diskNodesPair = new Hashtable<String, List<String>>();
        if (!nodeListResults.anySuccess()) {
            return diskNodesPair;
        }
        Hashtable ht = nodeListResults.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node;
            node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("retrieving the Disk names from Node : " + node));
            }
            if (result.getStatus() == 1) {
                String[] listDisksOutput = (String[])result.getResultInfoSet().elementAt(0);
                if (listDisksOutput == null || listDisksOutput.length == 0) continue;
                for (int i = 0; i < listDisksOutput.length; ++i) {
                    List<Object> nodes;
                    String diskName = listDisksOutput[i];
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("the Disk[" + i + "] on Node : " + node + " is: " + diskName));
                    }
                    if (diskNodesPair.containsKey(diskName)) {
                        nodes = diskNodesPair.get(diskName);
                        diskNodesPair.remove(diskName);
                        if (!nodes.contains(node)) {
                            nodes.add(node);
                        }
                        diskNodesPair.put(diskName, nodes);
                        continue;
                    }
                    nodes = new Vector();
                    ((Vector)nodes).add(node);
                    diskNodesPair.put(diskName, nodes);
                }
                continue;
            }
            if (failedNodes.contains(node)) continue;
            failedNodes.add(node);
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("DiskSet is {" + VerificationUtil.strCollection2String(diskNodesPair.keySet()) + "}"));
        }
        Set<String> diskSet = diskNodesPair.keySet();
        Object[] disksList = diskSet.toArray();
        for (int cnt1 = 0; cnt1 < disksList.length; ++cnt1) {
            String diskName = disksList[cnt1].toString();
            Vector tempnodes = (Vector)diskNodesPair.get(diskName);
            if (nodeList.length != tempnodes.size()) {
                for (String node : nodeList) {
                    if (tempnodes.contains(node)) {
                        tempnodes.remove(node);
                        continue;
                    }
                    if (failedNodes.contains(node)) continue;
                    tempnodes.add(node);
                }
            } else {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Found same Disk " + diskName + " on all nodes and hence removing it from the table"));
                }
                tempnodes.removeAllElements();
            }
            diskNodesPair.remove(diskName);
            if (tempnodes.size() <= 0) continue;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Nodes " + VerificationUtil.strCollection2String(tempnodes) + " are missing the disk " + diskName));
            }
            VerificationLogData.log("Nodes " + VerificationUtil.strCollection2String(tempnodes) + " are missing the disk " + diskName);
            diskNodesPair.put(diskName, tempnodes);
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Returning the table of size " + diskNodesPair.size()));
        }
        return diskNodesPair;
    }

    private boolean checkASMLibConfigParamConsistency(String[] nodeList, String configInfoFilePath, Vector<String> asmLibConfigNotConsistentNodes, Vector<String> operationFailedNode, ResultSet asmLibconfiguredRsltSet) {
        Trace.out((String)"ENTRY");
        Hashtable<String, HashMap<String, String>> nodeParamTable = new Hashtable<String, HashMap<String, String>>();
        HashMap<String, String> paramValue = null;
        String errMsg = null;
        Vector<String> goodNodes = new Vector<String>();
        Trace.out((String)"Checking the consistency of configuration of ASMLib on all nodes.");
        for (String node : nodeList) {
            Result nodeRes = new Result(node);
            paramValue = this.getPropertyValue(node, configInfoFilePath, this.m_asmLibConfigParameters, nodeRes, false);
            if (nodeRes.getStatus() == 1) {
                goodNodes.add(node);
                nodeParamTable.put(node, paramValue);
                asmLibconfiguredRsltSet.addResult(node, nodeRes);
                continue;
            }
            Trace.out((String)("Failed to read the configuration file from node " + node));
            errMsg = s_gMsgBundle.getMessage("10121", true, (Object[])new String[]{configInfoFilePath, node});
            nodeRes.addErrorDescription(new ErrorDescription(errMsg));
            asmLibconfiguredRsltSet.addResult(node, nodeRes);
            operationFailedNode.add(node);
        }
        Hashtable<String, Vector<String>> missMatchParamNodesPair = new Hashtable<String, Vector<String>>();
        for (String param : this.m_asmLibConfigParameters) {
            Trace.out((String)("Checking consistency of parameter " + param + " on all the nodes"));
            String prevValue = null;
            String curValue = null;
            boolean misMatch = false;
            boolean first = true;
            for (String node : goodNodes) {
                curValue = (String)((HashMap)nodeParamTable.get(node)).get(param);
                if (first) {
                    prevValue = (String)((HashMap)nodeParamTable.get(node)).get(param);
                    first = false;
                    continue;
                }
                if (prevValue != null && curValue != null && !prevValue.contentEquals(curValue)) {
                    misMatch = true;
                    break;
                }
                prevValue = (String)((HashMap)nodeParamTable.get(node)).get(param);
            }
            if (!misMatch) continue;
            Trace.out((String)("Parameter " + param + " is not consistent on nodes" + goodNodes.toString()));
            missMatchParamNodesPair.put(param, goodNodes);
        }
        if (missMatchParamNodesPair.size() > 0) {
            Set missMatchparams = missMatchParamNodesPair.keySet();
            for (String param : missMatchparams) {
                for (String node : goodNodes) {
                    Trace.out((String)("Setting the error message for missmatching Param " + param + " on node " + node));
                    errMsg = s_gMsgBundle.getMessage("10122", true, (Object[])new String[]{param, node});
                    asmLibconfiguredRsltSet.getResult(node).setStatus(3);
                    asmLibconfiguredRsltSet.getResult(node).addErrorDescription(new ErrorDescription(errMsg));
                    if (asmLibConfigNotConsistentNodes.contains(node)) continue;
                    asmLibConfigNotConsistentNodes.add(node);
                }
            }
        }
        Trace.out((String)"EXIT");
        return operationFailedNode.size() == 0 && asmLibConfigNotConsistentNodes.size() == 0;
    }

    private HashMap<String, String> getPropertyValue(String nodeName, String cnfgFilePath, String[] propNameList, Result result, boolean ignoreCase) {
        ErrorDescription errDesc = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String destinationFullPath = null;
        HashMap<String, String> propNameValPair = null;
        if (cnfgFilePath == null || cnfgFilePath.trim().length() == 0 || propNameList == null || propNameList.length == 0 || nodeName == null || nodeName.trim().length() == 0) {
            result.setStatus(2);
            return null;
        }
        String shortFileName = cnfgFilePath.substring(cnfgFilePath.lastIndexOf(File.separator) + 1);
        destinationFullPath = VerificationUtil.getDestLoc() + nodeName + "." + shortFileName;
        File localCnfgFileCopy = new File(destinationFullPath);
        try {
            localCnfgFileCopy.createNewFile();
        }
        catch (Exception e) {
            Trace.out((String)("Error creating file" + destinationFullPath));
            Trace.out((String)e.getMessage());
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7706", false, (Object[])new String[]{destinationFullPath}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        nativeSys.copyFile(nodeName, cnfgFilePath, "localnode", destinationFullPath);
        if (!localCnfgFileCopy.exists()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(destinationFullPath + " does not exist"));
            }
            errDesc = new ErrorDescription(s_msgBundle.getMessage("5311", false, (Object[])new String[]{destinationFullPath, nodeName}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        try {
            propNameValPair = new HashMap<String, String>();
            for (String propName : propNameList) {
                String propValue = Utils.getPropertyValue((String)localCnfgFileCopy.getAbsolutePath(), (String)propName, (boolean)ignoreCase);
                propNameValPair.put(propName, propValue);
            }
        }
        catch (FileNotFoundException e) {
            errDesc = new ErrorDescription(s_msgBundle.getMessage("5311", false, (Object[])new String[]{localCnfgFileCopy.getAbsolutePath(), nodeName}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            ReportUtil.printError(e.getMessage());
            Trace.out((Exception)e);
            return null;
        }
        catch (IOException e) {
            errDesc = new ErrorDescription(e.getMessage());
            result.addErrorDescription(errDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((Exception)e);
            result.setStatus(2);
            return null;
        }
        nativeSys.removeFile("localnode", localCnfgFileCopy.getAbsolutePath());
        result.setStatus(1);
        return propNameValPair;
    }
}

